<?php

namespace RFTenant\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RfAdditionalFeesLease extends Model 
{

    protected $table = 'rf_additional_fees_lease';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('rf_lease_id', 'rf_additional_fees', 'calculation_basis_id', 'payment_frequency_id', 'value');

    public function lease()
    {
        return $this->belongsTo('RfLease');
    }

    public function calculation_basis()
    {
        return $this->belongsTo('RFTenant\Models\RfLeaseSpecification', 'calculation_basis_id');
    }

    public function payment_frequency()
    {
        return $this->belongsTo('RFTenant\Models\RfLeaseSpecification', 'payment_frequency_id');
    }

}